/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.frame;

import lib.toma.animations.AnimationUtils;
import lib.toma.animations.IEasing;
import lib.toma.animations.Keyframes;
import lib.toma.animations.api.IKeyframe;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;

public class MutableKeyframe
implements IKeyframe {
    public float endpoint;
    public IEasing easing = AnimationUtils.DEFAULT_EASE_FUNC;
    public Vector3d position = Vector3d.field_186680_a;
    public Vector3d rotation = Vector3d.field_186680_a;
    private Vector3d pos0 = Vector3d.field_186680_a;
    private Vector3d rot0 = Vector3d.field_186680_a;
    private Vector3d relPos = Vector3d.field_186680_a;
    private Vector3d relRot = Vector3d.field_186680_a;
    private Quaternion rot0Quat = Quaternion.field_227060_a_;
    private Quaternion relRotQuat = Quaternion.field_227060_a_;

    public static MutableKeyframe fullCopyOf(IKeyframe frame) {
        MutableKeyframe mkf = MutableKeyframe.copyOf(frame);
        mkf.setPos0(frame.initialPosition());
        mkf.setRot0(frame.initialRotation());
        mkf.updateRelativePos();
        mkf.updateRelativeRot();
        return mkf;
    }

    public static MutableKeyframe copyOf(IKeyframe keyframe) {
        MutableKeyframe mkf = new MutableKeyframe();
        mkf.setEndpoint(keyframe.endpoint());
        mkf.setPosition(keyframe.positionTarget());
        mkf.setRotation(keyframe.rotationTarget());
        mkf.setEasing(keyframe.getEasing());
        return mkf;
    }

    @Override
    public float endpoint() {
        return this.endpoint;
    }

    public void setEndpoint(float endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public Vector3d positionTarget() {
        return this.position;
    }

    @Override
    public Vector3d relativePos() {
        return this.relPos;
    }

    public void setPosition(Vector3d position) {
        this.position = position;
        this.updateRelativePos();
    }

    @Override
    public Vector3d rotationTarget() {
        return this.rotation;
    }

    @Override
    public Vector3d relativeRot() {
        return this.relRot;
    }

    public void setRotation(Vector3d rotation) {
        this.rotation = rotation;
        this.updateRelativeRot();
    }

    @Override
    public Vector3d initialPosition() {
        return this.pos0;
    }

    public void setPos0(Vector3d pos0) {
        this.pos0 = pos0;
        this.updateRelativePos();
    }

    @Override
    public Vector3d initialRotation() {
        return this.rot0;
    }

    public void setRot0(Vector3d vector3d) {
        this.rot0 = vector3d;
        this.rot0Quat = Keyframes.rotationVector2Quaternion(this.rot0);
        this.updateRelativeRot();
    }

    @Override
    public void baseOn(IKeyframe parent) {
        this.pos0 = Keyframes.getInitialPosition(parent);
        this.rot0 = Keyframes.getInitialRotation(parent);
        this.rot0Quat = Keyframes.rotationVector2Quaternion(this.rot0);
        this.updateRelativePos();
        this.updateRelativeRot();
    }

    @Override
    public Quaternion getInitialRotationQuaternion() {
        return this.rot0Quat;
    }

    @Override
    public Quaternion getRotationQuaternion() {
        return this.relRotQuat;
    }

    @Override
    public IEasing getEasing() {
        return this.easing;
    }

    public void setEasing(IEasing easing) {
        this.easing = easing;
    }

    public String toString() {
        return "rotation=" + this.rotation + ", rot0=" + this.rot0 + ", relRot=" + this.relRot;
    }

    private void updateRelativePos() {
        this.relPos = Keyframes.getRelativePosition(this.position, this.pos0);
    }

    private void updateRelativeRot() {
        this.relRot = Keyframes.getRelativeRotation(this.rotation, this.rot0);
        this.relRotQuat = Keyframes.rotationVector2Quaternion(this.relRot);
    }
}

